/*-------------------------------------------------------------------------
This file is an adaptation of the file OgrePrerequisites.h from OGRE
and customised to our own needs
-------------------------------------------------------------------------*/
#ifndef __Prerequisites_H__
#define __Prerequisites_H__

// Platform-specific stuff
#include "Platform.h"

#if UOX_COMPILER == COMPILER_MSVC
// Turn off warnings generated by long std templates
// This warns about truncation to 255 characters in debug/browse info
#   pragma warning (disable : 4786)

// disable: "conversion from 'double' to 'float', possible loss of data
#   pragma warning (disable : 4244)

// disable: "truncation from 'double' to 'float'
#   pragma warning (disable : 4305)

// disable: "<type> needs to have dll-interface to be used by clients'
// Happens on STL member variables which are not public therefore is ok
#   pragma warning (disable : 4251)

// disable: "non dll-interface class used as base for dll-interface class"
// Happens when deriving from Singleton because bug in compiler ignores
// template export
#   pragma warning (disable : 4275)

// disable: "C++ Exception Specification ignored"
// This is because MSVC 6 did not implement all the C++ exception 
// specifications in the ANSI C++ draft.
#   pragma warning( disable : 4290 )

// disable: "no suitable definition provided for explicit template 
// instantiation request" Occurs in VC7 for no justifiable reason on all 
// #includes of Singleton
#   pragma warning( disable: 4661)

	#pragma warning( disable : 4511 )	// copy constructor could not be generated
	#pragma warning( disable : 4512 )	// assignment operator could not be generated
	#pragma warning( disable : 4663 )	// C++ language change: to explicitly specialize class template '' use the following syntax...

#endif

#if UOX_COMPILER == COMPILER_MSVC
#   undef _DEFINE_DEPRECATED_HASH_CLASSES
#   if UOX_COMP_VER > 1300
#       define _DEFINE_DEPRECATED_HASH_CLASSES 0
#   else
#      define _DEFINE_DEPRECATED_HASH_CLASSES 1
#   endif
#endif

/* Include all the standard header *after* all the configuration
   settings have been made.
*/
#include "UOXStdHeaders.h"

// define the real number values to be used
// default to use 'float' unless precompiler option set
namespace UOX {
    // Define UOX version
    #define UOX_VERSION_MAJOR 0
    #define UOX_VERSION_MINOR 14
    #define UOX_VERSION_PATCH 0

    // define the Char type as either char or wchar_t
    #if UOX_WCHAR_T_STRINGS == 1
    #   define UOXChar wchar_t
    #	define _TO_CHAR( x ) L##x
    #else
    #   define UOXChar char
    #	define _TO_CHAR( x ) x
    #endif

    #ifdef GCC_3_1
    #   define HashMap ::__gnu_cxx::hash_map
    #else
    #   if UOX_COMPILER == COMPILER_MSVC
    #       if UOX_COMP_VER > 1300 && !defined(_STLP_MSVC)
    #           define HashMap ::stdext::hash_map
    #       else
    #           define HashMap ::std::hash_map
    #       endif
    #   else
    #       define HashMap ::std::hash_map
    #   endif
    #endif

    /// Useful macros
    #define UOX_DELETE(p)       { if(p) { delete (p);     (p)=NULL; } }
    #define UOX_DELETE_ARRAY(p) { if(p) { delete[] (p);   (p)=NULL; } }


// Pre-declare classes
// Allows use of pointers in header files without including individual .h
// so decreases dependencies between files
	class CBaseTile;
	class cAccountClass;
	class CBaseObject;
	class cBooks;
	class CBoatObj;
	class CChar;
	class cCharStuff;
	class cCommands;
	class CConsole;
	class cDice;
	class CDictionary;
	class CDictionaryContainer;
	class cDirectoryListing;
	class CEndL;
	class cEffects;
	class CEnvoke;
	class CGuild;
	class CGuildCollection;
	class CGump;
	class cHTMLTemplate;
	class cHTMLTemplates;
	class cItem;
	class CItem;
	class CJSMapping;
	class CJSMappingSection;
	class CLand;
	class CLandHS;
	class cMagic;
	class CMagicMove;
	class CMagicStat;
	class CMapHandler;
	class CMapRegion;
	class CMulHandler;
	class cMovement;
	class CMultiObj;
	class cNetworkStuff;
	class CPUOXBuffer;
	class CPInputBuffer;
	class cRaces;
	class CRace;
	class cScript;
	class CServerData;
	class CServerDefinitions;
	class CServerProfile;
	class cSkillClass;
	class cSkills;
	class CSocket;
	class CSpawnItem;
	class CSpawnRegion;
	class CSpeechEntry;
	class CSpeechQueue;
	class CTEffect;
	class CThreadQueue;
	class CTile;
	class CTileHS;
	class CTileUni;
	class CTownRegion;
	class CVersionClass;
	class CWeather;
	class cWeatherAb;
	class CWeight;
	class cWhoList;
	class CWorldMain;
	class GumpDisplay;
	class HelpRequest;
	class JailCell;
	class JailSystem;
	class ObjectFactory;
	class Script;
	class ScriptSection;
	class SpellInfo;
	class UOXFile;
	class UString;

    /** In order to avoid finger-aches :)
    */
#include "enums.h"
#include "typedefs.h"

}

#endif // __Prerequisites_H__


